unit Unit1;

interface

uses
  SysUtils, Classes, HTTPApp, HTTPProd, DB, ADODB, DSProd, DBWeb,
  Variants; //TADODataSet.Locate

type
  TWebModule1 = class(TWebModule)
    FormPageProducer: TPageProducer;
    AddedPageProducer: TPageProducer;
    ErrorPageProducer: TPageProducer;
    RemovedPageProducer: TPageProducer;
    AboutPageProducer: TPageProducer;
    ADODataSet1: TADODataSet;
    DataSetTableProducer1: TDataSetTableProducer;
    ConfirmPageProducer: TPageProducer;
    CookiesPageProducer: TPageProducer;
    procedure WebModule1PostAction(Sender: TObject; Request: TWebRequest;
      Response: TWebResponse; var Handled: Boolean);
    procedure AddedPageProducerHTMLTag(Sender: TObject; Tag: TTag;
      const TagString: String; TagParams: TStrings;
      var ReplaceText: String);
    procedure WebModuleCreate(Sender: TObject);
    procedure WebModuleDestroy(Sender: TObject);
    procedure WebModuleException(Sender: TObject; E: Exception;
      var Handled: Boolean);
    procedure ConfirmPageProducerHTMLTag(Sender: TObject; Tag: TTag;
      const TagString: String; TagParams: TStrings;
      var ReplaceText: String);
    procedure WebModule1UpdateAction(Sender: TObject; Request: TWebRequest;
      Response: TWebResponse; var Handled: Boolean);
    procedure CookiesPageProducerHTMLTag(Sender: TObject; Tag: TTag;
      const TagString: String; TagParams: TStrings;
      var ReplaceText: String);
    procedure FormPageProducerHTMLTag(Sender: TObject; Tag: TTag;
      const TagString: String; TagParams: TStrings;
      var ReplaceText: String);
  private
    { Private declarations }
    komunikat :String;
    function ZapiszDoBazy(nazwisko,email,haslo,tytul,opis :String) :Boolean;
    function UsunZBazy(email,haslo :String) :Boolean;
    procedure SaveToLogFile(eventstr :AnsiString);
    procedure ZapiszCookies(nazwisko,email,haslo,tytul,opis,akcja :String);
  public
    { Public declarations }
  end;

var
  WebModule1: TWebModule1;

implementation

{$R *.dfm}

procedure TWebModule1.WebModule1PostAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var
  nazwisko,email,haslo,haslo2,tytul,opis :String;
  email_correct,haslo_zgodne,akcja :Boolean;
begin
email:=Request.ContentFields.Values['email'];
email_correct:=True;
nazwisko:=Request.ContentFields.Values['nazwisko'];
haslo:=Request.ContentFields.Values['haslo'];
haslo2:=Request.ContentFields.Values['haslo2'];
tytul:=Request.ContentFields.Values['tytul'];
opis:=Request.ContentFields.Values['opis'];

if Request.ContentFields.Values['akcja']='dodaj' then akcja:=True
                                                 else akcja:=False;

//Bledy
if Request.ContentFields.Values['nazwisko']='' then komunikat:='Wypenij pole "Imi i nazwisko"';
if Request.ContentFields.Values['tytul']='' then komunikat:='Wypenij pole "Tytu projektu"';
if Request.ContentFields.Values['opis']='' then komunikat:='Wypenij pole "Opis projektu"';

if (Pos('@',email)=0) or (Pos('.',email)=0) then
  begin
  email_correct:=False;
  komunikat:='Zly format e-maila.';
  end;

haslo_zgodne:=((haslo=haslo2) and (haslo<>''));
if not haslo_zgodne then komunikat:='Brak hasla lub potwierdzenie nie jest identyczne';

//Akcja
if akcja then

  begin //dodawanie do listy
  if (Request.ContentFields.Values['nazwisko']<>'')
     and email_correct
     and haslo_zgodne
     and (Request.ContentFields.Values['tytul']<>'')
     and (Request.ContentFields.Values['opis']<>'')
     then //dodawanie do listy, jak sprawdzone
       begin
       ZapiszCookies(nazwisko,email,haslo,tytul,opis,'dodaj');
       Response.Content:=ConfirmPageProducer.Content;
       {
       if ZapiszDoBazy(nazwisko,email,haslo,tytul,opis)
         then Response.Content:=AddedPageProducer.Content
         else begin
              komunikat:='Identyczny rekord istnieje.';
              Response.Content:=ErrorPageProducer.Content;
              end;
       }
       end
     else //dodawanie do listy, blad danych
       Response.Content:=ErrorPageProducer.Content;
  end

   else

   begin //usuwanie z listy
   if email_correct and haslo_zgodne then //usuwanie z listy, email i haslo OK
     begin
       ZapiszCookies(nazwisko,email,haslo,tytul,opis,'usun');
       Response.Content:=ConfirmPageProducer.Content;
       {
       if UsunZBazy(email,haslo)
          then Response.Content:=RemovedPageProducer.Content
          else begin
               komunikat:='W bazie danych nie ma rekordu zawierajcego podany e-mail i haslo';
               Response.Content:=ErrorPageProducer.Content
               end;
       }
     end
     else
     begin
     komunikat:='Niewypenione pole "e-mail" lub brak zgodnoci hasa.';
     Response.Content:=ErrorPageProducer.Content;
     end;
   end;

end;


function TWebModule1.ZapiszDoBazy(nazwisko,email,haslo,tytul,opis :String) :Boolean;
begin
Result:=True;
ADODataSet1.Open;
if ADODataSet1.Locate('email;tytul',VarArrayOf([email,tytul]),[loCaseInsensitive]) then
  begin
  Result:=False;
  Exit;
  end;
ADODataSet1.AppendRecord([nil,nazwisko,email,haslo,tytul,opis]); //nil dla automatycznego identyfikatora
ADODataSet1.Close;

SaveToLogFile('ZapiszDoBazy ('+email+')');
end;


function TWebModule1.UsunZBazy(email,haslo :String) :Boolean;
begin
Result:=False;

{
ADODataSet1.Open;
ADODataSet1.Filtered:=False;
ADODataSet1.Filter:='email = '+QuotedStr(email)+' AND haslo='+QuotedStr(haslo);
ADODataSet1.Filtered:=True;
ADODataSet1.DeleteRecords(arFiltered);
ADODataSet1.Filtered:=False;
ADODataSet1.Close;
}

ADODataSet1.Open;
ADODataSet1.Filter:='email = '+QuotedStr(email)+' AND haslo='+QuotedStr(haslo);
ADODataSet1.Filtered:=True;
while not ADODataSet1.Eof do //jezeli sie powtarzaja
//if not ADODataSet1.Eof then
  begin
  ADODataSet1.Delete;
  Result:=True;
  end;
ADODataSet1.Filtered:=False;
ADODataSet1.Close;

{ADODataSet1.Open;
ADOCommand1.CommandText:='DELETE FROM "Projekty" WHERE email='+QuotedStr(email)+' AND haslo='+QuotedStr(haslo);
ADOCommand1.Execute;
ADODataSet1.Close;}

SaveToLogFile('UsunZBazy ('+email+')');
end;

procedure TWebModule1.SaveToLogFile(eventstr :AnsiString);
const
  LogFileName='Project2c.log';
var
  LogFile: TextFile;
begin
AssignFile(LogFile,LogFileName);
if FileExists(LogFileName) then Append(LogFile) else Rewrite(LogFile);
WriteLn(LogFile,eventstr+': '+DateToStr(Date)+', '+TimeToStr(Time));
CloseFile(LogFile);
end;


procedure TWebModule1.WebModuleCreate(Sender: TObject);
begin
SaveToLogFile('Start');
//raise Exception.Create('Wywolanie bledu do testowania OnException');
end;

procedure TWebModule1.WebModuleDestroy(Sender: TObject);
begin
SaveToLogFile('Stop');
end;

procedure TWebModule1.WebModuleException(Sender: TObject; E: Exception;
  var Handled: Boolean);
begin
SaveToLogFile('Blad! ('+E.Message+')');
end;

// DODANE w Project2c
procedure TWebModule1.ZapiszCookies(nazwisko,email,haslo,tytul,opis,akcja :String);
var Lista :TStringList;
begin
//Zapisz do cookie
Lista:=TStringList.Create;
Lista.Add('nazwisko='+nazwisko);
Lista.Add('email='+email);
Lista.Add('haslo='+haslo);
Lista.Add('tytul='+tytul);
Lista.Add('opis='+opis);
Lista.Add('akcja='+akcja);
Response.SetCookieField(Lista,'','',Now+1,False);
end;

procedure TWebModule1.WebModule1UpdateAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var nazwisko,email,haslo,tytul,opis :String;
    akcja :Boolean;
begin
nazwisko:=Request.CookieFields.Values['nazwisko'];
email:=Request.CookieFields.Values['email'];
haslo:=Request.CookieFields.Values['haslo'];
tytul:=Request.CookieFields.Values['tytul'];
opis:=Request.CookieFields.Values['opis'];
akcja:=(Request.CookieFields.Values['akcja']='dodaj');

if akcja
  then
  if ZapiszDoBazy(nazwisko,email,haslo,tytul,opis)
    then Response.Content:=AddedPageProducer.Content
    else begin
         komunikat:='Identyczny rekord istnieje.';
         Response.Content:=ErrorPageProducer.Content;
         end

  else

  if UsunZBazy(email,haslo)
    then Response.Content:=RemovedPageProducer.Content
    else begin
         komunikat:='W bazie danych nie ma rekordu zawierajcego podany e-mail i haslo';
         Response.Content:=ErrorPageProducer.Content
         end;
end;


procedure TWebModule1.FormPageProducerHTMLTag(Sender: TObject; Tag: TTag;
  const TagString: String; TagParams: TStrings; var ReplaceText: String);
var remotehost :AnsiString;
begin
//Tytul i naglowek
if TagString='tytul' then ReplaceText:='Jacek Matulewski - Projekty zaliczeniowe';
if TagString='naglowek' then ReplaceText:='Projekty zaliczeniowe';

//Informacje o zdalnym komputerze
if TagString='remotehost' then
    begin
    remotehost:=Request.RemoteHost;
    if remotehost<>Request.RemoteAddr then remotehost:=remotehost+' ('+Request.RemoteAddr+')';
    ReplaceText:=remotehost;
    SaveToLogFile('RemoteHost='+remotehost);
    end;
if TagString='browser' then ReplaceText:=Request.UserAgent;
end;


procedure TWebModule1.ConfirmPageProducerHTMLTag(Sender: TObject;
  Tag: TTag; const TagString: String; TagParams: TStrings;
  var ReplaceText: String);
var akcja :Boolean;
begin
//Tytul i naglowek
FormPageProducerHTMLTag(Sender,Tag,TagString,TagParams,ReplaceText);

//Dane pobrane bezposrednio z formularza
if TagString='email' then ReplaceText:=Request.ContentFields.Values['email'];
if TagString='nazwisko' then ReplaceText:=Request.ContentFields.Values['nazwisko'];
if TagString='temat' then ReplaceText:=Request.ContentFields.Values['tytul'];
if TagString='opis' then ReplaceText:=Request.ContentFields.Values['opis'];

if Request.ContentFields.Values['akcja']='dodaj' then akcja:=True
                                                 else akcja:=False;
if TagString='akcja' then
  begin
  if akcja then ReplaceText:='Dodaj do bazy' else ReplaceText:='Usu z bazy';
  SaveToLogFile('Potwierdzenie ('+ReplaceText+')');
  end;
end;


procedure TWebModule1.AddedPageProducerHTMLTag(Sender: TObject; Tag: TTag;
  const TagString: String; TagParams: TStrings; var ReplaceText: String);
begin
//Tytul i naglowek
FormPageProducerHTMLTag(Sender,Tag,TagString,TagParams,ReplaceText);

//Dane pobierane z pliku cookie
if TagString='email' then ReplaceText:=Request.CookieFields.Values['email'];
if TagString='nazwisko' then ReplaceText:=Request.CookieFields.Values['nazwisko'];
if TagString='temat' then ReplaceText:=Request.CookieFields.Values['tytul'];

if TagString='komunikat' then ReplaceText:=komunikat;
end;


procedure TWebModule1.CookiesPageProducerHTMLTag(Sender: TObject;
  Tag: TTag; const TagString: String; TagParams: TStrings;
  var ReplaceText: String);
var i :Integer;
begin
//Domylne teksty, takie jak nagwek
AddedPageProducerHTMLTag(Sender,Tag,TagString,TagParams,ReplaceText);

if TagString='c_pola' then
  begin
  ReplaceText:='Ilo pl w pliku cookies: '+IntToStr(Request.CookieFields.Count)+'<BR>';
  for i:=0 to Request.CookieFields.Count-1 do ReplaceText:=ReplaceText+Request.CookieFields.Strings[i]+'<BR>';
  end;

if TagString='c_nazwisko' then ReplaceText:=Request.CookieFields.Values['nazwisko'];
if TagString='c_email' then ReplaceText:=Request.CookieFields.Values['email'];
if TagString='c_temat' then ReplaceText:=Request.CookieFields.Values['tytul'];
if TagString='c_opis' then ReplaceText:=Request.CookieFields.Values['opis'];
if TagString='c_akcja' then
  if Request.CookieFields.Values['akcja']='dodaj' then ReplaceText:='dodaj do bazy danych'
                                                  else ReplaceText:='usu z bazy danych';
end;


end.
